<?php
/*********************************
	Drupal Z-Ray Extension
	Version: 1.00
**********************************/
$drupalExt = new ZRayExtensionDrupal8();
$zre = new \ZRayExtension('drupal8');

$zre->setMetadata(array(
	'logo' => __DIR__ . DIRECTORY_SEPARATOR . 'logo.png',
));

$zre->setEnabledAfter('Drupal\Core\DrupalKernel::bootEnvironment');

$zre->traceFunction('Drupal\Core\Extension\ModuleHandler::getImplementations', function(){}, array($drupalExt, 'ModuleInvoke'));
$zre->traceFunction('Drupal\Core\Extension\ModuleHandler::getModuleList', function(){}, array($drupalExt, 'DrupalLoad'));
$zre->traceFunction('call_user_func', function(){}, array($drupalExt, 'UserFunctions'));
$zre->traceFunction('call_user_func_array', function(){}, array($drupalExt, 'Events'));
$zre->traceFunction('Drupal\Core\Form\FormBuilder::prepareForm', function(){}, array($drupalExt, 'getForm'));
$zre->traceFunction('Drupal::currentUser', function(){}, array($drupalExt, 'GetUser'));

// tracing locks
$zre->traceFunction('acquire', function(){}, array($drupalExt, 'LockAcquire'));
$zre->traceFunction('release', function(){}, array($drupalExt, 'LockRelease'));
$zre->traceFunction('wait', function(){}, array($drupalExt, 'LockWait'));
	
class ZRayExtensionDrupal8 {
    
    public $storagedUsers = array();
    public $called = array();
    
	public function ModuleInvoke($context, & $storage) {
		$implementations = $context['returnValue'];
		$hook = $context['functionArgs'][0];
		foreach ($implementations as $module) {
			$function = $module . '_' . $hook;
			$storage['moduleInvoke'][$module] = array('module' => $module, 'action' => $function, 'hook' => $hook);
		}
	}
	
	public function DrupalLoad($context, & $storage) {
		$moduleList = $context['returnValue'];
		foreach ($moduleList as $name => $module) {
			$storage['LoadedModules'][$name] = array('module' => $module);
		}
	}
	
	public function Events($context, & $storage) {
		$called = $context['functionArgs'][0];
		$parameter = isset($context['functionArgs'][1]) ? $context['functionArgs'][1] : '';
		$blob = isset($context['functionArgs'][2]) ? json_encode($context['functionArgs'][2]) : '';
		
		if (!in_array($called, $this->called) && ! $this->is_closure($called) && ! $this->is_closure($parameter) && ! $this->is_closure($blob) && ! is_array($called) && ! is_object($called) && $called != 'class_exists' && 
		    $this->isSerializable($parameter)) {
		    $storage['CalledFunctions'][$called] = array('called' => $called, 'parameter' => $parameter, 'info' => $blob);
			array_push($this->called, $called);
		}
	}
	
	public function UserFunctions($context, & $storage) {
	    $called = $context['functionArgs'][0];
	    $blob = isset($context['functionArgs'][2]) ? json_encode($context['functionArgs'][2]) : '';
	
	    // not saving $parameter as in Events trace because it causes to fatal error
	    if (!in_array($called, $this->called) && ! $this->is_closure($called) && ! $this->is_closure($blob) && ! is_array($called) && ! is_object($called) && $called != 'class_exists') {
	        $storage['CalledFunctions'][$called] = array('called' => $called, 'info' => $blob);
	        array_push($this->called, $called);
	    }
	}
	
	public function GetUser($context, & $storage) {
	   if (!in_array ($context['returnValue']->getAccountName(), $this->storagedUsers)) {
	       $this->storagedUsers[$context['returnValue']->id()] = $context['returnValue']->getAccountName();
	       $storage['User'][$context['returnValue']->id()][] = $context['returnValue'];
	   }
	}
	
	public function LockAcquire($context, & $storage) {
		$storage['locks'][] = array('action' => 'Acquire', 'name' => $context['functionArgs'][0]);
	}
	
	public function LockRelease($context, & $storage) {
		$storage['locks'][] = array('action' => 'Release', 'name' => $context['functionArgs'][0]);
	}
	
	public function LockWait($context, & $storage) {
		$storage['locks'][] = array('action' => 'Wait', 'name' => $context['functionArgs'][0]);
	}
	
	public function getForm($context, & $storage) {
	    
	 	$storage['RetrievedForms'][] = array(
	 			$context['locals']['form']['#attributes']['class'][0] => $context['locals']['form']);
	 	
	}
	
	private function isSerializable($value) {
	    $return = true;
	    $arr = array($value);
	
	    array_walk_recursive($arr, function ($element) use (&$return) {
	        if (is_object($element) && get_class($element) == 'Closure') {
	            $return = false;
	        }
	    });
	
	    return $return;
	}
	
	private function is_closure($t) {
		return is_object($t) && get_class($t) == 'Closure' && is_resource($t) ;
	}
}