<?php

namespace MongoDb;

class MongoDb {

    protected $queries  = [];

    protected $commands = [];

    protected $writes = [];

    protected function setDeleteData($context) {

        $options = '';

        if(array_key_exists(1 , $context['functionArgs'])) {
            $options = json_encode($context['functionArgs'][1]);
        }

        return [
            'method'     => 'delete',
            'document'   => '',
            'condition'  => json_encode($context['functionArgs'][0]),
            'options'    => $options,
        ];

    }

    protected function setUpdateData($context) {
        $options = '';

        if(array_key_exists(2 , $context['functionArgs'])) {
            $options = json_encode($context['functionArgs'][2]);
        }

        return [
            'method'     => 'update',
            'document'   => json_encode($context['functionArgs'][1]),
            'condition'  => json_encode($context['functionArgs'][0]),
            'options'    => $options,
        ];
    }

    protected function setInsertData($context) {

        return [
            'method'     => 'insert',
            'document'   => json_encode($context['functionArgs'][0]),
            'condition'  => '',
            'options'    => '',
        ];
    }

    public function getWrite($context) {

        $method = 'set' . ucfirst(str_replace('MongoDB\Driver\BulkWrite::' , '' , $context['functionName'])) . 'Data';
        $id = spl_object_hash($context['this']);

        $this->writes[$id][] = $this->$method($context);

    }

    public function getWriteConcern($method , $result) {

        $matched  = 0;
        $modified = 0;
        $inserted = 0;

        if(empty($result)) {
            return [
                'matched'  => 'N/A',
                'modified' => 'N/A',
                'inserted' => 'N/A',
            ];
        }

        switch($method) {

            case 'insert':
                var_dump($result);
                $matched  = $result->getInsertedCount();
                $inserted = $result->getInsertedCount();
                break;
            case 'update':
                $matched  = $result->getMatchedCount();
                $inserted = $result->getUpsertedCount();
                $modified = $result->getModifiedCount();
                break;
            case 'delete':
                $modified = $result->getDeletedCount();
                break;
        }

        return [
            'matched'  => $matched,
            'modified' => $modified,
            'inserted' => $inserted,
        ];

    }

    public function traceWrite($context, &$storage) {

        $result = $context['returnValue'];
        $namespace = $context['functionArgs'][0];
        $id = spl_object_hash($context['functionArgs'][1]);

        $params = [];

        foreach($this->writes[$id] as $operation) {

            $method = $operation['method'];
            $parsedResult = $this->getWriteConcern($method , $result);

            $params[] = [
                'collection' => $namespace,
                'method'     => $method,
                'document'   => $operation['document'],
                'condition'  => $operation['condition'],
                'options'    => $operation['options'],
                'matched'    => $parsedResult['matched'],
                'modified'   => $parsedResult['modified'],
                'inserted'   => $parsedResult['inserted'],
                'status'     => $this->getStatus($context),
            ];
        }
        $storage['writes'] = $params;
    }

    public function getCommand($context) {
        $query     = $context['functionArgs'][0];
        $id = spl_object_hash($context['this']);

        $this->commands[$id] = [
            'command'  => json_encode($query),
        ];
    }

    public function traceCommand($context, &$storage) {
        $database     = $context['functionArgs'][0];
        $query        = $context['functionArgs'][1];

        $id = spl_object_hash($query);

        $storage['commands'][] = [
            'database' => $database,
            'command'  => $this->commands[$id]['command'],
            'status'    => $this->getStatus($context),
        ];
    }

    public function getQuery($context) {

        $query     = $context['functionArgs'][0];
        $options   = $context['functionArgs'][1];
        $id = spl_object_hash($context['this']);

        $limit = 0;
        $skip  = 0;
        $sort  = '';

        if(array_key_exists('limit' , $options)) {
            $limit = $options['limit'];
        }

        if(array_key_exists('skip' , $options)) {
            $skip = $options['skip'];
        }

        if(array_key_exists('sort' , $options)) {
            $sort = json_encode($options['sort']);
        }

        $this->queries[$id] = [
            'query' => json_encode($query),
            'limit' => $limit,
            'skip'  => $skip,
            'sort'  => $sort,

        ];

    }

    public function traceQuery($context, &$storage) {

        $namespace = $context['functionArgs'][0];
        $query     = $context['functionArgs'][1];

        $id = spl_object_hash($query);

        $queryInfo = $this->queries[$id];

        $storage['queries'][] = [
            'collection' => $namespace,
            'query'      => $queryInfo['query'],
            'sort'       => $queryInfo['sort'],
            'skip'       => $queryInfo['skip'],
            'limit'      => $queryInfo['limit'],
            'status'     => $this->getStatus($context),
        ];


    }

    protected function getStatus($context) {
        return ($context['exceptionThrown'] == true)?'ko':'ok';
    }

}


$mongoDb = new MongoDb();

$zre = new \ZRayExtension("mongoDB");

$zre->setMetadata(array(
    'logo' => __DIR__ . DIRECTORY_SEPARATOR . 'z-phongo.jpg',
    'foo' => 'bar',
));

$zre->traceFunction('MongoDB\Driver\BulkWrite::delete', function() {}, [$mongoDb , 'getWrite']);
$zre->traceFunction('MongoDB\Driver\BulkWrite::insert', function() {}, [$mongoDb , 'getWrite']);
$zre->traceFunction('MongoDB\Driver\BulkWrite::update', function() {}, [$mongoDb , 'getWrite']);

$zre->traceFunction('MongoDB\Driver\Manager::executeBulkWrite', function() {}, [$mongoDb , 'traceWrite']);

$zre->traceFunction('MongoDB\Driver\Command::__construct', function() {}, [$mongoDb , 'getCommand']);

$zre->traceFunction('MongoDB\Driver\Manager::executeCommand', function() {}, [$mongoDb , 'traceCommand']);

$zre->traceFunction('MongoDB\Driver\Query::__construct', function() {}, [$mongoDb , 'getQuery']);

$zre->traceFunction('MongoDB\Driver\Manager::executeQuery', function() {}, [$mongoDb , 'traceQuery']);

$zre->setEnabledAfter('MongoDB\Driver\Manager::__construct');
?>
