<?php

namespace Mongo;


class Mongo {


    public function viewFindOneQuery($context, &$storage) {

        /**
         * @var \MongoCollection $collection
         */
        $collection = $context['this'];

        $query  = $context["functionArgs"][0];

        $storage['queries'][] = [
            'collection' => $collection->getName(),
            'method'    => 'findOne',
            'query'     => json_encode($query),
            'time'      =>  $context['durationExclusive']/1000 . ' s',
            'count'     => (($context['returnValue'] === false)?0:1),
        ];
    }

    public function viewFindQuery($context, &$storage) {
        /**
         * @var \MongoCollection $collection
         */
        $collection = $context['this'];

        /**
         * @var \MongoCursor $cursor
         */
        $cursor = $context['returnValue'];

        $query  = $context["functionArgs"][0];

        $storage['queries'][] = [
            'collection' => $collection->getName(),
            'method'     => 'find',
            'query'      => json_encode($query),
            'time'       => $context['durationExclusive']/1000 . ' s',
            'count'      => (($cursor === false)?0:$cursor->count()),
        ];
    }

    public function getQueryParams($context, &$storage) {
        /**
         * @var \MongoCursor $cursor
         */
        $cursor = $context['this'];
        $info   = $cursor->info();
        $query  = $info['query'];
        $method = str_replace('MongoCursor::' , '' , $context['functionName']);

        $value  = $context['functionArgs'][0];
        if(is_array($value)) {
            $value = json_encode($value);
        }


        $storage['cursor'][] = [
            'collection'   => $info['ns'],
            'query'        => json_encode($query),
            'method'       => $method,
            'value'        => $value,
        ];

    }

    public function traceUpdateQuery($context, &$storage) {
        /**
         * @var \MongoCollection $collection
         */
        $collection = $context['this'];

        $method    = str_replace('MongoCollection::' , '' , $context['functionName']);
        $query     = $context["functionArgs"][1];
        $condition = $context["functionArgs"][0];

        $return = $context['returnValue'];

        if(is_array($return)) {
            $return = json_encode($return);
        }

        $storage['write'][] = [
            'collection' => $collection->getName(),
            'method'     => $method,
            'conditions' => json_encode($condition),
            'query'      => json_encode($query),
            'time'       => $context['durationExclusive']/1000 . ' s',
            'result'     => $return,
        ];
    }

    public function traceInsertQuery($context, &$storage) {
        /**
         * @var \MongoCollection $collection
         */
        $collection = $context['this'];

        $method    = str_replace('MongoCollection::' , '' , $context['functionName']);
        $query     = $context["functionArgs"][0];

        $return = $context['returnValue'];

        if(is_array($return)) {
            $return = json_encode($return);
        }

        $storage['write'][] = [
            'collection' => $collection->getName(),
            'method'     => $method,
            'conditions' => '',
            'query'      => json_encode($query),
            'time'       => $context['durationExclusive']/1000 . ' s',
            'result'     => $return,
        ];
    }

    public function traceRemoveQuery($context, &$storage) {
        /**
         * @var \MongoCollection $collection
         */
        $collection = $context['this'];

        $method    = str_replace('MongoCollection::' , '' , $context['functionName']);
        $query     = $context["functionArgs"][0];

        $return = $context['returnValue'];

        if(is_array($return)) {
            $return = json_encode($return);
        }

        $storage['write'][] = [
            'collection' => $collection->getName(),
            'method'     => $method,
            'conditions' => json_encode($query),
            'query'      => '',
            'time'       => $context['durationExclusive']/1000 . ' s',
            'result'     => $return,
        ];
    }

}

$zre = new \ZRayExtension("Mongo");
$Mongo = new Mongo();

$zre->setMetadata(array(
    'logo' => __DIR__ . DIRECTORY_SEPARATOR . 'logo.zray.mongo.php5.png',
));

$zre->setEnabledAfter('MongoClient::__construct');

$zre->traceFunction("MongoCollection::findOne",  function(){ }, array($Mongo, 'viewFindOneQuery'));
$zre->traceFunction("MongoCollection::find",  function(){  }, array($Mongo, 'viewFindQuery'));

$zre->traceFunction("MongoCollection::update",  function(){  }, array($Mongo, 'traceUpdateQuery'));
$zre->traceFunction("MongoCollection::insert",  function(){  }, array($Mongo, 'traceInsertQuery'));
$zre->traceFunction("MongoCollection::remove",  function(){  }, array($Mongo, 'traceRemoveQuery'));

$zre->traceFunction("MongoCursor::sort",  function(){ }, array($Mongo, 'getQueryParams'));
$zre->traceFunction("MongoCursor::limit",  function(){ }, array($Mongo, 'getQueryParams'));
$zre->traceFunction("MongoCursor::skip",  function(){ }, array($Mongo, 'getQueryParams'));
