<?php
use yii\base\InlineAction;
use yii\log\Target;
use yii\debug\LogTarget;
use yii\log\Logger;

class Yii2 {

    public function getConfigInfo($context, &$storage)
    {
        $configInfo =  [
            'phpVersion' => PHP_VERSION,
            'yiiVersion' => Yii::getVersion(),
            'application' => [
                'yii' => Yii::getVersion(),
                'name' => Yii::$app->name,
                'env' => YII_ENV,
                'debug' => YII_DEBUG,
            ],
            'php' => [
                'version' => PHP_VERSION,
                'xdebug' => !empty(extension_loaded('xdebug')) ? 'Yes' : 'No',
                'apc' => !empty(extension_loaded('apc')) ? 'Yes' : 'No',
                'memcache' => !empty(extension_loaded('memcache')) ? 'Yes' : 'No',
            ],
            'extensions' => Yii::$app->extensions,
        ];

        $storage['configInfo'][] = array('name'=>'Yii2 Version','value'=> $configInfo['yiiVersion']);
		$storage['configInfo'][] = array('name'=>'Application Name','value'=> $configInfo['application']['name']);
		$storage['configInfo'][] = array('name'=>'Environment','value'=> $configInfo['application']['env']);
		$storage['configInfo'][] = array('name'=>'Debug Mode','value'=> $configInfo['application']['debug'] ? 'Yes' : 'No');

        $storage['configInfo'][] = array('name'=>'PHP Version','value'=> $configInfo['phpVersion']);
        $storage['configInfo'][] = array('name'=>'APC','value'=> $configInfo['php']['apc']);
        $storage['configInfo'][] = array('name'=>'XDebug','value'=> $configInfo['php']['xdebug']);
        $storage['configInfo'][] = array('name'=>'Memcache','value'=> $configInfo['php']['memcache']);

    }

    public function getPageInfo($context, &$storage)
    {
        $info = $this->getInfo();
		$storage['pageInfo'][] = array('name'=>'Route','value'=> $info['route']);
		$storage['pageInfo'][] = array('name'=>'Status Code','value'=> $info['statusCode']);
		$storage['pageInfo'][] = array('name'=>'Action','value'=> $info['action']);
    }


	public function getExtensions($context, &$storage)
    {
        $data = [];
        foreach (Yii::$app->extensions as $extension) {
            $data[$extension['name']] = $extension['version'];
        }
        ksort($data);

        foreach ($data as $key => $value) {
            $storage['extensions'][] = array('name'=> $key,'value'=> $value);
        }
	}


    public function getAssetBundles($context, &$storage)
    {
        $bundles = Yii::$app->view->assetManager->bundles;

        foreach ($bundles as $title => $bundle) {
            $js = $css = $depends = '';
            if (!empty ($bundle->js)) {
                $js = implode('<br/>', $bundle->js);
            }
            if (!empty ($bundle->css)) {
                $css = implode('<br/>', $bundle->css);
            }
            if (!empty ($bundle->depends)) {
                $depends = implode('<br/>', $bundle->depends);
            }

            $storage['bundles'][] = [
                'title' => $title,
                'sourcePath' => $bundle->sourcePath,
                'basePath' => $bundle->basePath,
                'js' => $js,
                'css' => $css,
                'depends' => $depends,
            ];
        }
    }

    protected function getQueryType($timing)
    {
        $timing = ltrim($timing);
        preg_match('/^([a-zA-z]*)/', $timing, $matches);
        return count($matches) ? mb_strtoupper($matches[0], 'utf8') : '';
    }

    public function getDbTimings($context, &$storage)
    {
        $messages = Yii::getLogger()->messages;
        $timings = Yii::getLogger()->calculateTimings($messages);

        foreach ($timings as $seq => $dbTiming) {

            $timeInSeconds = $dbTiming['timestamp'];
            $millisecondsDiff = (int) (($timeInSeconds - (int) $timeInSeconds) * 1000);
            $time =  date('H:i:s.', $timeInSeconds) . sprintf('%03d', $millisecondsDiff);
            $duration = sprintf('%.1f ms', $dbTiming['duration']*1000);

            if (!empty($dbTiming['trace'])) {
                foreach ($dbTiming['trace'] as $trace) {
                    $traceArr[] = $trace['file'].' ('.$trace['line'].')';
                }
            }

            $storage['dblogger'][] = [
                'type' => $this->getQueryType($dbTiming['info']),
                'query' => $dbTiming['info'],
                'duration' => $duration, // in milliseconds
                'trace' => implode('<br/>', $traceArr),
                'timestamp' => $time, // in milliseconds
                'seq' => $seq,
            ];
        }

    }

    public function getLogs($context, &$storage)
    {
        $messages = Yii::getLogger()->messages;
        $filter = [
                Logger::LEVEL_TRACE => 'Trace',
                Logger::LEVEL_INFO => 'Info',
                Logger::LEVEL_WARNING => 'Warning',
                Logger::LEVEL_ERROR => 'Error',
                Logger::LEVEL_PROFILE => 'Profile Message',
                Logger::LEVEL_PROFILE_BEGIN => 'Profile Begin',
                Logger::LEVEL_PROFILE_END => 'Profile End',
        ];

        foreach ($messages as $message) {
            $timeInSeconds = $message[3];
            $millisecondsDiff = (int) (($timeInSeconds - (int) $timeInSeconds) * 1000);
            $time =  date('H:i:s.', $timeInSeconds) . sprintf('%03d', $millisecondsDiff);

            $storage['logger'][] = 	[
                'message' => $message[0],
                'log-level' => $filter[$message[1]],
                'category' => $message[2],
                'time' => $time,
            ];
        }

    }

    protected function getInfo()
    {
        $headers = Yii::$app->getRequest()->getHeaders();
        $requestHeaders = [];
        foreach ($headers as $name => $value) {
            if (is_array($value) && count($value) == 1) {
                $requestHeaders[$name] = current($value);
            } else {
                $requestHeaders[$name] = $value;
            }
        }

        $responseHeaders = [];
        foreach (headers_list() as $header) {
            if (($pos = strpos($header, ':')) !== false) {
                $name = substr($header, 0, $pos);
                $value = trim(substr($header, $pos + 1));
                if (isset($responseHeaders[$name])) {
                    if (!is_array($responseHeaders[$name])) {
                        $responseHeaders[$name] = [$responseHeaders[$name], $value];
                    } else {
                        $responseHeaders[$name][] = $value;
                    }
                } else {
                    $responseHeaders[$name] = $value;
                }
            } else {
                $responseHeaders[] = $header;
            }
        }
        if (Yii::$app->requestedAction) {
            if (Yii::$app->requestedAction instanceof InlineAction) {
                $action = get_class(Yii::$app->requestedAction->controller) . '::' . Yii::$app->requestedAction->actionMethod . '()';
            } else {
                $action = get_class(Yii::$app->requestedAction) . '::run()';
            }
        } else {
            $action = null;
        }

        return [
            'flashes' => $this->getFlashes(),
            'statusCode' => Yii::$app->getResponse()->getStatusCode(),
            'requestHeaders' => $requestHeaders,
            'responseHeaders' => $responseHeaders,
            'route' => Yii::$app->requestedAction ? Yii::$app->requestedAction->getUniqueId() : Yii::$app->requestedRoute,
            'action' => $action,
            'actionParams' => Yii::$app->requestedParams,
            'requestBody' => Yii::$app->getRequest()->getRawBody() == '' ? [] : [
                'Content Type' => Yii::$app->getRequest()->getContentType(),
                'Raw' => Yii::$app->getRequest()->getRawBody(),
                'Decoded to Params' => Yii::$app->getRequest()->getBodyParams(),
            ],
            'SERVER' => empty($_SERVER) ? [] : $_SERVER,
            'GET' => empty($_GET) ? [] : $_GET,
            'POST' => empty($_POST) ? [] : $_POST,
            'COOKIE' => empty($_COOKIE) ? [] : $_COOKIE,
            'FILES' => empty($_FILES) ? [] : $_FILES,
            'SESSION' => empty($_SESSION) ? [] : $_SESSION,
        ];
    }
    protected function getFlashes()
    {
        $session = Yii::$app->has('session', true) ? Yii::$app->get('session') : null;
        if ($session === null) {
            return [];
        }

        $counters = $session->get($session->flashParam, []);
        $flashes = [];
        foreach (array_keys($counters) as $key) {
            if (array_key_exists($key, $_SESSION)) {
                $flashes[$key] = $_SESSION[$key];
            }
        }
        return $flashes;
    }

}

$zre = new \ZRayExtension('Yii2');
$zreYii2 = new Yii2;

$zre->setMetadata(array(
	'logo' => __DIR__ . DIRECTORY_SEPARATOR . 'logo.png',
));
$zre->setEnabledAfter('yii\base\Application::run');

$zre->traceFunction('yii\base\Controller::runAction', function () {}, array($zreYii2, 'getConfigInfo'));
$zre->traceFunction('yii\base\InlineAction::runWithParams', function () {}, array($zreYii2, 'getPageInfo'));
$zre->traceFunction('yii\base\Controller::runAction', function () {}, array($zreYii2, 'getDbTimings'));
$zre->traceFunction('yii\base\Controller::runAction', function () {}, array($zreYii2, 'getLogs'));
$zre->traceFunction('yii\base\Controller::runAction', function () {}, array($zreYii2, 'getExtensions'));
$zre->traceFunction('yii\base\Controller::runAction', function () {}, array($zreYii2, 'getAssetBundles'));
$zre->traceFunction('yii\base\Controller::runAction', function () {}, array($zreYii2, 'getBehaviours'));
